/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class ECDSAPublicKey
extends PublicKey {
    protected ByteArrayAttribute ecdsaParams_;
    protected ByteArrayAttribute ecPoint_;

    public ECDSAPublicKey() {
        this.keyType_.setLongValue(Key.KeyType.ECDSA);
    }

    protected ECDSAPublicKey(Session session, long l) throws TokenException {
        super(session, l);
        this.keyType_.setLongValue(Key.KeyType.ECDSA);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.ecdsaParams_ = new ByteArrayAttribute(Attribute.ECDSA_PARAMS);
        this.ecPoint_ = new ByteArrayAttribute(Attribute.EC_POINT);
        ECDSAPublicKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        ECDSAPublicKey eCDSAPublicKey = (ECDSAPublicKey)super.clone();
        eCDSAPublicKey.ecdsaParams_ = (ByteArrayAttribute)this.ecdsaParams_.clone();
        eCDSAPublicKey.ecPoint_ = (ByteArrayAttribute)this.ecPoint_.clone();
        ECDSAPublicKey.putAttributesInTable(eCDSAPublicKey);
        return eCDSAPublicKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof ECDSAPublicKey) {
            ECDSAPublicKey eCDSAPublicKey = (ECDSAPublicKey)object;
            bl = this == eCDSAPublicKey || super.equals(eCDSAPublicKey) && this.ecdsaParams_.equals(eCDSAPublicKey.ecdsaParams_) && this.ecPoint_.equals(eCDSAPublicKey.ecPoint_);
        }
        return bl;
    }

    public ByteArrayAttribute getEcPoint() {
        return this.ecPoint_;
    }

    public ByteArrayAttribute getEcdsaParams() {
        return this.ecdsaParams_;
    }

    public static Object getInstance(Session session, long l) throws TokenException {
        return new ECDSAPublicKey(session, l);
    }

    protected static void putAttributesInTable(ECDSAPublicKey eCDSAPublicKey) {
        if (eCDSAPublicKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        eCDSAPublicKey.attributeTable_.put(Attribute.ECDSA_PARAMS, eCDSAPublicKey.ecdsaParams_);
        eCDSAPublicKey.attributeTable_.put(Attribute.EC_POINT, eCDSAPublicKey.ecPoint_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.ecdsaParams_);
        Object.getAttributeValue(session, this.objectHandle_, this.ecPoint_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("ECDSA Params (DER, hex): ");
        stringBuffer.append(this.ecdsaParams_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("EC Point (DER, hex): ");
        stringBuffer.append(this.ecPoint_.toString());
        return stringBuffer.toString();
    }
}

